/**
 * 
 */
package gov.va.genisis2.ms.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 
 * @author PII
 *
 */
@Entity
@Table(name = "concept_mapping_data_elements")
public class ConceptMappingDataElement implements Serializable {

	private static final long serialVersionUID = -1054242260957965843L;

	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private int id;

	@Column(name = "concept_uri")
	private String conceptUri;

	@Column(name = "data_element_id")
	private int dataElementId;

	@Column(name = "concept_mapping_id", insertable = false, updatable = false)
	private int conceptMappingId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "concept_mapping_id")
	private ConceptMapping conceptMapping;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri
	 *            the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the dataElementId
	 */
	public int getDataElementId() {
		return dataElementId;
	}

	/**
	 * @param dataElementId
	 *            the dataElementId to set
	 */
	public void setDataElementId(int dataElementId) {
		this.dataElementId = dataElementId;
	}

	/**
	 * @return the conceptMappingId
	 */
	public int getConceptMappingId() {
		return conceptMappingId;
	}

	/**
	 * @param conceptMappingId
	 *            the conceptMappingId to set
	 */
	public void setConceptMappingId(int conceptMappingId) {
		this.conceptMappingId = conceptMappingId;
	}

	/**
	 * @return the conceptMapping
	 */
	public ConceptMapping getConceptMapping() {
		return conceptMapping;
	}

	/**
	 * @param conceptMapping
	 *            the conceptMapping to set
	 */
	public void setConceptMapping(ConceptMapping conceptMapping) {
		this.conceptMapping = conceptMapping;
	}
}
